VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "Comdlg32.ocx"
Begin VB.Form Form1 
   Caption         =   "ControlHandling"
   ClientHeight    =   4860
   ClientLeft      =   2535
   ClientTop       =   2235
   ClientWidth     =   6705
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   4860
   ScaleWidth      =   6705
   Begin MSComDlg.CommonDialog dlgFile 
      Left            =   300
      Top             =   4140
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.PictureBox Picture1 
      BackColor       =   &H80000005&
      Height          =   3435
      Left            =   60
      ScaleHeight     =   3375
      ScaleWidth      =   4455
      TabIndex        =   1
      Top             =   60
      Width           =   4515
      Begin VB.PictureBox shpHook 
         Appearance      =   0  '2D
         BackColor       =   &H00FF0000&
         ForeColor       =   &H80000008&
         Height          =   135
         Index           =   0
         Left            =   0
         ScaleHeight     =   105
         ScaleWidth      =   105
         TabIndex        =   2
         Top             =   0
         Visible         =   0   'False
         Width           =   135
      End
      Begin VB.Image imgHotSpot 
         Appearance      =   0  '2D
         BorderStyle     =   1  'Fest Einfach
         Height          =   435
         Index           =   0
         Left            =   0
         Top             =   0
         Visible         =   0   'False
         Width           =   1095
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "&Add"
      Height          =   495
      Left            =   4680
      TabIndex        =   0
      Top             =   60
      Width           =   1095
   End
   Begin VB.Menu mnuDatei 
      Caption         =   "&Datei"
      Begin VB.Menu mnuDateiffnen 
         Caption         =   "&ffnen"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'###################################################################################
'  Autor:            Benjamin Battran
'  Erstellt:         06.07.1999
'  Letzte nderung:  07.07.1999
'###################################################################################
'  Kleines Projekt, das einen Ansatz demonstriert, wie in einem Programm zur
'  Laufzeit Controls hinzugefgt, positioniert und deren Gre gendert werden
'  kann.
'  Das ganze verhlt sich in etwa so wie die Dialoggestaltung unter Visual Basic
'  (der Visual-Anteil eben)
'  Das hier vorliegende Projekt soll mal ein Hot-Spot Editor fr Bitmaps werden,
'  lt sich aber auch entsprechend abwandeln, etwa fr einen Formulareditor oder
'  eine Visual-Programmierumgebung ...
'  Sorry, wenn's win bichen quick-and-dirty aussieht, aber genau so ist es auch
'  entstanden, nachdem ich wiedermal nirgends eine entsprechende Vorlage gefunden
'  habe, hab' ich mir gedacht, dann mach' ich mir das eben schnell (!) selbst
'  -> Zur freien verfgung!
'###################################################################################


Private MarkedControl As Control    'Das aktuell ausgewhlte Steuerelement
Dim OldX1, OldY1, OldX2, OldY2      'Speichert Rahmenposition fr Neuzeichnung
Dim xx, yy                          'Startkoordinaten
Private KeyDown As Boolean          'True wenn linke Maustaste gedrckt
Private Moving As Boolean           'True, wenn ein Steuerelement neu positioniert wird
Private Draw As Boolean             'True, wenn ein Steuerelement neu erstellt werden soll
Private Drawing As Boolean          'True, wenn ein Steuerelement neu erstellt wird
Private Const gap = 15              'Lcke zwischen Control und Hooks




Private Sub Command1_Click()
'Wenn True, kann ein neues Steuerelement in Picture1 gezeichnet werden
Draw = Not Draw
End Sub

Private Sub Form_Load()
'Hooks zur Steuerelementmarkierung definieren
'-> aus 1 mach 8
Dim i
shpHook(0).Width = 100
shpHook(0).Height = shpHook(0).Width
For i = 1 To 7
   Load shpHook(i)
Next
End Sub


Sub CtlMark(Cntl As Control)
'Das bergebene Steuerelement wird markiert
'Alle acht Hooks werden entsprechend um das Steuerelement plaziert
'Und markedControl fr als aktuelles Steuerelement mit diesem belegt
If Not MarkedControl Is Nothing Then MarkedControl.MousePointer = 0
   SetHook 0, Cntl.Left, Cntl.Top - gap, -1, -1, vbSizeNWSE
   SetHook 1, Cntl.Left + Cntl.Width / 2, Cntl.Top - gap, -0.5, -1, vbSizeNS
   SetHook 2, Cntl.Left + Cntl.Width, Cntl.Top - gap, 0, -1, vbSizeNESW
   SetHook 3, Cntl.Left + Cntl.Width + gap, Cntl.Top + Cntl.Height / 2, 0, -0.5, vbSizeWE
   SetHook 4, Cntl.Left + Cntl.Width, Cntl.Top + Cntl.Height + gap, 0, 0, vbSizeNWSE
   SetHook 5, Cntl.Left + Cntl.Width / 2, Cntl.Top + Cntl.Height + gap, -0.5, 0, vbSizeNS
   SetHook 6, Cntl.Left, Cntl.Top + Cntl.Height + gap, -1, 0, vbSizeNESW
   SetHook 7, Cntl.Left - gap, Cntl.Top + Cntl.Height / 2, -1, -0.5, vbSizeWE
   Set MarkedControl = Cntl
   ShowMark True
   MarkedControl.MousePointer = 15
End Sub

Sub SetHook(ByVal Index, ByVal X, ByVal Y, ByVal xdir, ByVal ydir, Optional Pointer As Variant)
'Positioniert den Hook mit dem bergebenen Index
   shpHook(Index).Top = Y + ydir * shpHook(Index).Height
   shpHook(Index).Left = X + xdir * shpHook(Index).Width
   shpHook(Index).ZOrder
   If Not IsMissing(Pointer) Then
      shpHook(Index).MousePointer = Pointer
   End If
End Sub




Sub ShowMark(ByVal ShowHide As Boolean)
'Anzeigen oder ausblenden der gesamten markieren
'True=anzeigen, false=ausblenden
Dim i
For i = 0 To shpHook.Count - 1
   shpHook(i).Visible = ShowHide
   shpHook(i).ZOrder
Next
End Sub

Private Sub Form_Resize()
'Anpassen der Steuerelemente bei Grennderung
On Error Resume Next
   Picture1.Width = Me.ScaleWidth - Command1.Width - 3 * Picture1.Left
   Picture1.Height = Me.ScaleHeight - 2 * Picture1.Top
   Command1.Left = Picture1.Left + Picture1.Width + Picture1.Left
On Error GoTo 0
End Sub

Private Sub imgHotSpot_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Markierein dieses Steuerelementes
CtlMark imgHotSpot(Index)
End Sub

Private Sub imgHotSpot_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Steuerelement positionieren (=ziehen mit der Maus)
CtlMove imgHotSpot(Index), Button, X, Y

'Setzen des ToolTipTextes auf die aktuellen Koordinaten
imgHotSpot(Index).ToolTipText = imgHotSpot(Index).Left & "," & imgHotSpot(Index).Top
End Sub

Private Sub imgHotSpot_MouseUp(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Beenden der Positionierung (=neuzeichnen des Steuerelementes)
CtlEndMove imgHotSpot(Index), Button
End Sub

Private Sub mnuDateiffnen_Click()
'Laden eines Bitmap als Hintergrund fr Picture1
dlgFile.CancelError = True
dlgFile.Filter = "Bitmap (*.bmp)|*.bmp"
dlgFile.FilterIndex = 0
On Error Resume Next
   dlgFile.ShowOpen
   If Err.Number = 0 Then
      On Error GoTo 0
      Picture1.Picture = LoadPicture(dlgFile.filename)
   End If
On Error GoTo 0

End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
'Zurcksetzen der Markierung wenn ins Leere geklickt
ShowMark False

End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'Zeichenen eines neuen Steuerelementes
If Draw Then
   'Mauszeiger, wenn Zeichnen erlaubt
   Picture1.MousePointer = 2
Else
   'Normaler Mauszeiger
   Picture1.MousePointer = 0
End If
If Button = 1 Then
   'Wenn Zeichnen erlaubt
   If Draw Then
      'Wenn noch nicht mit Zeichnen begonnen
      If Not Drawing Then
         'Startwerte setzen
         xx = X
         yy = Y
         Drawing = True
      Else
         'Wenn bereits mit Zeichnen begonnen, Zeichenrahmen aktualisieren
         Picture1.Refresh
         DrawRect2 Picture1, xx, yy, X, Y
      End If
   End If
End If
End Sub

Private Sub Picture1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'Beenden der Neuzeichnung eines Steuerelementes
Dim tmp As Long
Dim newNdx As Long
'Wenn Zeichnen erlaubt
If Draw Then
   'Zeichnen verbieten und Zeichenvorgang als beendet kennzeichnen,
   'sowie den Zeichenrahmen entfernen
   Draw = False
   Drawing = False
   DrawRect2 Picture1, 0, 0, 0, 0
   'Old.. Werte halten die letzte Rahmendimensionierung
   'mssen ggf. ausgetauscht werden, es mu sein ..2 > ..1 um
   'negative Gren zu vermeiden
   If OldX1 > OldX2 Then
      tmp = OldX1
      OldX1 = OldX2
      OldX2 = tmp
   End If
   If OldY1 > OldY2 Then
      tmp = OldY1
      OldY1 = OldY2
      OldY2 = tmp
   End If
   'Wurde berhaupt etwas gezeichnet, oder nur dumm geklickt
   '(mindestgre ist also erforderlich)
   If (OldX2 - OldX1) > 25 And (OldY2 - OldY1 > 25) Then
      'neues Steuerelement erstellen und entsprechend der
      'letzten Rahmenposition dimensionieren
      newNdx = imgHotSpot.Count
      Load imgHotSpot(newNdx)
      imgHotSpot(newNdx).Top = OldY1
      imgHotSpot(newNdx).Left = OldX1
      imgHotSpot(newNdx).Width = OldX2 - OldX1
      imgHotSpot(newNdx).Height = OldY2 - OldY1
      imgHotSpot(newNdx).Visible = True
      'am besten gleich auch noch markieren
      CtlMark imgHotSpot(newNdx)
      Picture1.Refresh
   End If
End If
End Sub

Private Sub shpHook_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Wir steuern auf eine Grennderung zu, deshalb die markierung schon mal ausblenden
If Button = 1 Then
   ShowMark False
   KeyDown = True
End If
End Sub

Private Sub shpHook_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Die gre wird gendert und je nach gewhltem Hook, das Zeichenrechteck mit
'der aktuellen gre gezeichnet
If KeyDown And Button = 1 Then
   MarkedControl.Visible = False
   With MarkedControl
   Picture1.Refresh
      Select Case Index
         Case 0
            'oben-links
            DrawRect .Left + X, .Top + Y + gap, .Left + .Width, .Top + .Height
         Case 1
            'oben-mitte
            DrawRect .Left, .Top + Y + gap, .Left + .Width, .Top + .Height
         Case 2
            'oben-rechts
            DrawRect .Left, .Top + Y + gap, .Left + .Width + X, .Top + .Height
         Case 3
            'mitte-rechts
            DrawRect .Left, .Top, .Left + .Width + X - gap, .Top + .Height
         Case 4
            'unten rechts
            DrawRect .Left, .Top, .Left + .Width + X, .Top + .Height + Y - gap
         Case 5
            'unten-mitte
            DrawRect .Left, .Top, .Left + .Width, .Top + .Height + Y - gap
         Case 6
            'unten-links
            DrawRect .Left + X, .Top, .Left + .Width, .Top + .Height + Y - gap
         Case 7
            'mitte-links
            DrawRect .Left + X + gap, .Top, .Left + .Width, .Top + .Height
         End Select
   End With
End If
End Sub

Private Sub shpHook_MouseUp(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'Wenn der Hook wieder losgelassen wurde, dann Rahmen entfernen und
'das Steuerelement in Richtiger gre neu Zeichnen
Dim tmp
If Button = 1 Then ShowMark True
DrawRect 0, 0, 0, 0
If OldY1 > OldY2 Then
   tmp = OldY1
   OldY1 = OldY2
   OldY2 = tmp
End If
If OldX1 > OldX2 Then
   tmp = OldX1
   OldX1 = OldX2
   OldX2 = tmp
End If

MarkedControl.Top = OldY1
MarkedControl.Height = OldY2 - OldY1
MarkedControl.Left = OldX1
MarkedControl.Width = OldX2 - OldX1
MarkedControl.Visible = True
MarkedControl.Container.Refresh
KeyDown = False
'Markierung anpassen
CtlMark MarkedControl

End Sub

Sub DrawRect(x1, y1, x2, y2)
'Zeichnet oder entfernt ein Rechteck mit bergebenen Dimensionen
'bei Gennderung mit Hook
Const min = 0
Refresh

MarkedControl.Container.DrawWidth = 2
MarkedControl.Container.DrawMode = vbXorPen


If x1 > x2 - min Then
   x2 = OldX2 + min
   x1 = x2
End If
If y1 > y2 - min Then
   y2 = OldY2 + min
   y1 = y2
End If
MarkedControl.Container.Line (OldX1, OldY1)-(OldX2, OldY2), MarkedControl.Container.BackColor, B
If (x1 + x2 + y1 + y2) <> 0 Then
   MarkedControl.Container.Line (x1, y1)-(x2, y2), , B
   OldX1 = x1: OldY1 = y1
   OldX2 = x2: OldY2 = y2
End If
End Sub

Sub CtlMove(ctl As Control, Button, X, Y)
'Positionieren des Zeichenrahmens (und des Contrrols)
'Bei Move des Steuerelemntes
If Button = 1 Then
   If Not Moving Then
      xx = X
      yy = Y
      Moving = True
      ctl.Visible = False
      ShowMark False
      ctl.Container.Refresh
      DrawRect ctl.Left, ctl.Top, ctl.Left + ctl.Width, ctl.Top + ctl.Height
   Else
      ctl.Container.Refresh
      MarkedControl.Move MarkedControl.Left + X - xx, MarkedControl.Top + Y - yy
      DrawRect ctl.Left, ctl.Top, ctl.Left + ctl.Width, ctl.Top + ctl.Height
   End If
End If
End Sub

Sub CtlEndMove(ctl As Control, Button)
'Positionierung abgeschlossen:
'->Rahmen entfernen Control anzeigen und Markierung erneuern
   If Button = 1 And Moving Then
      Moving = False
      CtlMark MarkedControl
      ShowMark True
      DrawRect 0, 0, 0, 0
      ctl.Visible = True
      Picture1.Refresh
   End If
   
End Sub

Sub DrawRect2(ctl As Control, x1, y1, x2, y2)
'Zeichenrechteck beim neuzeichnen eines Steuerelementes in Picture1
Const min = 0
Refresh

ctl.DrawWidth = 2
ctl.DrawMode = vbXorPen
ctl.Line (OldX1, OldY1)-(OldX2, OldY2), ctl.BackColor, B
ctl.Refresh
If (x1 + x2 + y1 + y2) <> 0 Then
   ctl.Line (x1, y1)-(x2, y2), QBColor(8), B
   OldX1 = x1: OldY1 = y1
   OldX2 = x2: OldY2 = y2
End If
End Sub

